# 🍫 Falala Chocolate — Booking & Payment System

Sistem pemesanan online untuk **Falala Chocolate** dengan verifikasi pembayaran otomatis via [Moota.co](https://moota.co). Dibangun dengan Laravel 10, menghadirkan pengalaman pemesanan yang cepat dan seamless bagi customer maupun admin.

---

## ✨ Fitur Utama

### 🛒 Customer-Facing
- **Form Pemesanan** — Pilih produk, isi data, pilih store pickup, langsung checkout
- **Kode Unik Pembayaran** — Setiap order mendapat nominal unik agar verifikasi otomatis akurat
- **Halaman Konfirmasi** — Detail order, info transfer, countdown timer, dan status real-time
- **Upload Bukti Transfer** — Customer bisa upload bukti bayar langsung dari halaman konfirmasi
- **Auto-Expiry** — Order yang belum dibayar otomatis expired dalam **1 jam**

### 🔄 Payment Verification
- **Webhook Moota (Real-time)** — Mutasi masuk langsung dicocokkan dengan order pending
- **Cron Polling (Fallback)** — Backup verifikasi setiap menit via Moota API
- **Signature Verification** — Webhook diamankan dengan HMAC-SHA256
- **Manual Verify** — Admin bisa trigger verifikasi manual per order

### 🏪 Admin Panel
- **Dashboard** — Overview order, revenue, dan status pembayaran
- **Manajemen Order** — Lihat detail, verifikasi, input pickup code, mark complete
- **Pickup Code** — Admin input kode unik, customer tunjukkan saat ambil barang di store
- **Bukti Transfer** — Preview gambar bukti bayar langsung di halaman order detail
- **Sync Bank Moota** — Sinkronisasi akun bank dari Moota dengan satu klik
- **Master Data** — Kelola produk, lokasi store, dan akun bank
- **Reports** — Laporan penjualan dan pembayaran

---

## 🛠 Tech Stack

| Layer | Teknologi |
|-------|-----------|
| Backend | Laravel 10 (PHP 8.1+) |
| Database | MySQL 8.0 |
| Frontend | Blade + TailwindCSS CDN |
| Payment | Moota.co API v2 (Direct HTTP) |
| Queue | Laravel Queue (database driver) |
| Scheduler | Laravel Task Scheduling |

---

## 🚀 Deployment Guide

### Prerequisites
- PHP 8.1+
- Composer 2.x
- MySQL 8.0+
- Web Server (Nginx / Apache)

### 1. Clone & Install

```bash
git clone git@gitlab.com:gotralabs/booking-falala.git
cd booking-falala

composer install --no-dev --optimize-autoloader
```

### 2. Environment Setup

```bash
cp .env.example .env
php artisan key:generate
```

Edit `.env` sesuai environment:

```env
# Database
DB_HOST=127.0.0.1
DB_DATABASE=booking_falala
DB_USERNAME=your_db_user
DB_PASSWORD=your_db_password

# Moota Payment Gateway
MOOTA_API_TOKEN=your_moota_api_token
MOOTA_WEBHOOK_SECRET=your_webhook_secret
```

### 3. Database

```bash
php artisan migrate
```

### 4. Storage & Permissions

```bash
# Buat direktori upload bukti transfer
mkdir -p public/uploads
chmod -R 775 storage bootstrap/cache public/uploads
```

### 5. Sync Bank dari Moota

Buka Admin Panel → **Banks** → klik **Sync dari Moota**, atau via CLI:

```bash
php artisan tinker --execute="app(App\Services\MootaService::class)->getAllBankAccounts()"
```

### 6. Web Server (Nginx)

```nginx
server {
    listen 80;
    server_name booking.falalachocolate.com;
    root /var/www/booking-falala/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/run/php/php8.1-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }

    # Upload size untuk bukti transfer
    client_max_body_size 10M;
}
```

### 7. Cron Job & Queue Worker

```bash
# Crontab (wajib untuk auto-verify & expired orders)
* * * * * cd /var/www/booking-falala && php artisan schedule:run >> /dev/null 2>&1

# Queue Worker (wajib untuk background jobs)
# Disarankan menggunakan Supervisor
php artisan queue:work --sleep=3 --tries=3 --max-time=3600
```

**Supervisor config** (`/etc/supervisor/conf.d/booking-worker.conf`):

```ini
[program:booking-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /var/www/booking-falala/artisan queue:work --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
numprocs=1
redirect_stderr=true
stdout_logfile=/var/www/booking-falala/storage/logs/worker.log
stopwaitsecs=3600
```

```bash
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start booking-worker:*
```

### 8. Moota Webhook

Daftarkan webhook URL di [Dashboard Moota](https://app.moota.co):

```
URL:    https://yourdomain.com/api/webhooks/moota
Method: POST
```

Salin **Webhook Secret** dari Moota dan masukkan ke `.env`:

```env
MOOTA_WEBHOOK_SECRET=secret_dari_moota_dashboard
```

---

## 📂 Struktur Penting

```
app/
├── Console/Kernel.php              # Scheduler (verify + cleanup)
├── Http/Controllers/
│   ├── Admin/                      # Admin panel controllers
│   ├── BookingController.php       # Form pemesanan & konfirmasi
│   └── MootaWebhookController.php  # Webhook handler
├── Jobs/
│   └── CleanupExpiredOrdersJob.php # Auto-expire unpaid orders
├── Models/                         # Order, Product, Bank, dll
└── Services/
    ├── MootaService.php            # Direct HTTP ke Moota API
    ├── OrderService.php            # Business logic order
    ├── PaymentVerificationService.php  # Auto-matching pembayaran
    └── UniqueCodeService.php       # Generate kode unik nominal
```

---

## 🔐 Keamanan

- CSRF protection pada semua form, excluded untuk webhook endpoint
- Webhook signature verification (HMAC-SHA256)
- File upload validation (type + size limit 5MB)
- Prepared statements via Eloquent ORM
- Input sanitization pada semua form

---

## 📋 Scheduled Tasks

| Task | Interval | Fungsi |
|------|----------|--------|
| `verify-pending-orders` | Setiap 1 menit | Cek mutasi Moota untuk semua order pending |
| `cleanup-expired-orders` | Setiap 1 jam | Tandai order expired yang belum dibayar |

---

## 🧪 Development

```bash
# Jalankan dev server
php artisan serve

# Jalankan scheduler (lokal)
php artisan schedule:work

# Jalankan queue (lokal)
php artisan queue:work

# Clear cache
php artisan config:clear && php artisan cache:clear
```

---

## 📄 License

Proprietary — © 2026 Gotrasoft × Falala Chocolate. All rights reserved.
