<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Verify pending orders every 1 minute (fallback if webhook fails)
        $schedule->call(function () {
            app(\App\Services\PaymentVerificationService::class)->verifyPendingOrders();
        })->everyMinute()->name('verify-pending-orders')->withoutOverlapping();

        // Cleanup expired orders every hour
        $schedule->job(new \App\Jobs\CleanupExpiredOrdersJob)->hourly()->name('cleanup-expired-orders');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
