<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Product;
use App\Models\Bank;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Today's statistics
        $todayOrders = Order::whereDate('created_at', today())->count();
        $todayRevenue = Order::whereDate('created_at', today())
            ->whereIn('status', ['confirm', 'complete'])
            ->sum('total_amount');

        // Overall statistics
        $totalOrders = Order::count();
        $pendingOrders = Order::pending()->notExpired()->count();
        $confirmedOrders = Order::confirmed()->count();
        $completedOrders = Order::complete()->count();

        // Recent orders
        $recentOrders = Order::with(['storeLocation'])
            ->latest()
            ->limit(10)
            ->get();

        // Low stock products
        $lowStockProducts = Product::where('stock', '<', 10)
            ->where('is_active', true)
            ->get();

        // Banks
        $banks = Bank::active()->get();

        // Webhook URL for Moota
        $webhookUrl = url('/api/webhooks/moota');

        // Revenue by day (last 7 days)
        $revenueByDay = Order::whereIn('status', ['confirm', 'complete'])
            ->where('created_at', '>=', now()->subDays(7))
            ->select(
                DB::raw('DATE(created_at) as date'),
                DB::raw('SUM(total_amount) as total'),
                DB::raw('COUNT(*) as count')
            )
            ->groupBy('date')
            ->orderBy('date')
            ->get();

        return view('admin.dashboard', compact(
            'todayOrders',
            'todayRevenue',
            'totalOrders',
            'pendingOrders',
            'confirmedOrders',
            'completedOrders',
            'recentOrders',
            'lowStockProducts',
            'banks',
            'webhookUrl',
            'revenueByDay',
        ));
    }
}
