<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique();

            // Customer info
            $table->string('customer_name');
            $table->string('customer_whatsapp');
            $table->text('customer_address');
            $table->text('notes')->nullable();

            // Relationships
            $table->foreignId('store_location_id')->constrained();
            $table->foreignId('bank_id')->constrained();

            // Amounts
            $table->decimal('subtotal', 15, 2);
            $table->decimal('ppn', 15, 2);
            $table->unsignedSmallInteger('unique_code');
            $table->decimal('total_amount', 15, 2);

            // Status: pending, confirm, complete
            $table->enum('status', ['pending', 'confirm', 'complete'])->default('pending');
            $table->timestamp('expired_at')->nullable()->index();
            $table->timestamp('paid_at')->nullable();
            $table->timestamp('completed_at')->nullable();

            // Moota verification
            $table->string('moota_mutation_id')->nullable()->index();

            $table->timestamps();

            // Composite indexes for high-performance queries
            $table->index(['status', 'created_at']);
            $table->index(['total_amount', 'status', 'expired_at']);
            $table->index(['status', 'expired_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
