@extends('layouts.admin')

@section('title', 'Banks')
@section('page-title', 'Manage Banks')

@section('page-actions')
    <div class="flex space-x-2">
        <form action="{{ route('admin.banks.sync') }}" method="POST" class="inline">
            @csrf
            <button type="submit"
                class="bg-gray-100 text-navy px-4 py-2 rounded-lg text-sm font-medium hover:bg-gray-200">Sync from
                Moota</button>
        </form>
        <a href="{{ route('admin.banks.create') }}"
            class="bg-navy text-gold px-4 py-2 rounded-lg text-sm font-medium hover:bg-navy-light">+ Add Bank</a>
    </div>
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-sm border border-gray-100">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 text-xs text-gray-500 uppercase">
                    <tr>
                        <th class="px-4 py-3 text-left">Bank</th>
                        <th class="px-4 py-3 text-left">Account</th>
                        <th class="px-4 py-3 text-left">Moota ID</th>
                        <th class="px-4 py-3 text-center">Status</th>
                        <th class="px-4 py-3 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($banks as $bank)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 font-medium text-navy">{{ $bank->bank_name }}</td>
                            <td class="px-4 py-3">
                                <p class="text-sm">{{ $bank->account_number }}</p>
                                <p class="text-xs text-gray-400">{{ $bank->account_name }}</p>
                            </td>
                            <td class="px-4 py-3 text-xs font-mono text-gray-500">{{ $bank->moota_bank_id }}</td>
                            <td class="px-4 py-3 text-center">
                                @if($bank->is_active)
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full">Active</span>
                                @else
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-gray-100 text-gray-600 rounded-full">Inactive</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-center">
                                <div class="flex justify-center space-x-2">
                                    <a href="{{ route('admin.banks.edit', $bank) }}"
                                        class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                    </a>
                                    <form action="{{ route('admin.banks.destroy', $bank) }}" method="POST"
                                        onsubmit="return confirm('Hapus bank ini?')">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="p-2 text-red-600 hover:bg-red-50 rounded-lg">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                </path>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-4 py-8 text-center text-gray-400">No banks found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 border-t border-gray-100">{{ $banks->links() }}</div>
    </div>
@endsection