@extends('layouts.admin')

@section('title', 'Order Detail')
@section('page-title', 'Order ' . $order->order_number)

@section('content')
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Order Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Items -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Order Items</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="text-xs text-gray-500 uppercase bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left">Product</th>
                                <th class="px-4 py-2 text-center">Qty</th>
                                <th class="px-4 py-2 text-right">Price</th>
                                <th class="px-4 py-2 text-right">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            @foreach($order->items as $item)
                                <tr>
                                    <td class="px-4 py-3">{{ $item->product_name }}</td>
                                    <td class="px-4 py-3 text-center">{{ $item->quantity }}</td>
                                    <td class="px-4 py-3 text-right">Rp {{ number_format($item->unit_price, 0, ',', '.') }}</td>
                                    <td class="px-4 py-3 text-right font-medium">Rp
                                        {{ number_format($item->subtotal, 0, ',', '.') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4 pt-4 border-t space-y-2 text-sm">
                    <div class="flex justify-between"><span class="text-gray-500">Subtotal</span><span>Rp
                            {{ number_format($order->subtotal, 0, ',', '.') }}</span></div>
                    <div class="flex justify-between"><span class="text-gray-500">PPN (11%)</span><span>Rp
                            {{ number_format($order->ppn, 0, ',', '.') }}</span></div>
                    <div class="flex justify-between text-gold"><span>Kode Unik</span><span>+ Rp
                            {{ $order->unique_code }}</span></div>
                    <div class="flex justify-between text-lg font-bold border-t pt-2"><span>Total</span><span
                            class="text-navy">Rp {{ number_format($order->total_amount, 0, ',', '.') }}</span></div>
                </div>
            </div>

            <!-- Customer Info -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Customer Information</h3>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <p class="text-gray-500">Name</p>
                        <p class="font-medium">{{ $order->customer_name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500">WhatsApp</p>
                        <p class="font-medium">{{ $order->customer_whatsapp }}</p>
                    </div>
                    <div class="col-span-2">
                        <p class="text-gray-500">Address</p>
                        <p class="font-medium">{{ $order->customer_address }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500">Pickup Location</p>
                        <p class="font-medium">{{ $order->storeLocation->name ?? '-' }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500">Bank</p>
                        <p class="font-medium">{{ $order->bank->bank_name ?? '-' }}</p>
                    </div>
                    @if($order->notes)
                        <div class="col-span-2">
                            <p class="text-gray-500">Notes</p>
                            <p class="font-medium">{{ $order->notes }}</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Payment Proof -->
            @if($order->payment_proof)
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-4">Bukti Transfer</h3>
                    <a href="{{ asset($order->payment_proof) }}" target="_blank" class="block">
                        <img src="{{ asset($order->payment_proof) }}" alt="Bukti Transfer"
                            class="w-full rounded-lg border border-gray-200 hover:opacity-90 transition-opacity cursor-pointer">
                    </a>
                    <p class="text-xs text-gray-500 mt-2 text-center">Klik gambar untuk melihat ukuran penuh</p>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status Card -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Order Status</h3>
                <div class="text-center py-4">
                    @if($order->status === 'pending')
                        <div
                            class="inline-flex items-center px-4 py-2 bg-yellow-100 text-yellow-800 rounded-full text-sm font-semibold">
                            Pending Payment</div>
                    @elseif($order->status === 'confirm')
                        <div
                            class="inline-flex items-center px-4 py-2 bg-blue-100 text-blue-800 rounded-full text-sm font-semibold">
                            Payment Confirmed</div>
                    @else
                        <div
                            class="inline-flex items-center px-4 py-2 bg-green-100 text-green-800 rounded-full text-sm font-semibold">
                            Completed</div>
                    @endif
                </div>

                <div class="mt-4 space-y-2 text-sm">
                    <div class="flex justify-between"><span
                            class="text-gray-500">Created</span><span>{{ $order->created_at->format('d M Y H:i') }}</span>
                    </div>
                    @if($order->expired_at)
                        <div class="flex justify-between"><span class="text-gray-500">Expires</span><span
                                class="{{ $order->isExpired() ? 'text-red-600' : '' }}">{{ $order->expired_at->format('d M Y H:i') }}</span>
                        </div>
                    @endif
                    @if($order->paid_at)
                        <div class="flex justify-between"><span class="text-gray-500">Paid</span><span
                                class="text-green-600">{{ $order->paid_at->format('d M Y H:i') }}</span></div>
                    @endif
                </div>

                <!-- Actions -->
                <div class="mt-6 space-y-2">
                    @if($order->isPending())
                        <form action="{{ route('admin.orders.verify', $order) }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="w-full bg-blue-500 text-white py-2 rounded-lg hover:bg-blue-600 text-sm font-medium">Verify
                                Payment (Moota)</button>
                        </form>
                        <form action="{{ route('admin.orders.confirm', $order) }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="w-full bg-gold text-navy py-2 rounded-lg hover:bg-gold-dark text-sm font-medium">Manual
                                Confirm</button>
                        </form>
                        <form action="{{ route('admin.orders.cancel', $order) }}" method="POST"
                            onsubmit="return confirm('Cancel order ini?')">
                            @csrf
                            <button type="submit"
                                class="w-full bg-red-500 text-white py-2 rounded-lg hover:bg-red-600 text-sm font-medium">Cancel
                                Order</button>
                        </form>
                    @elseif($order->isConfirmed())
                        <form action="{{ route('admin.orders.complete', $order) }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="w-full bg-green-500 text-white py-2 rounded-lg hover:bg-green-600 text-sm font-medium">Mark
                                as Complete</button>
                        </form>
                    @endif
                </div>
            </div>

            <!-- Pickup Code -->
            @if($order->isConfirmed() || $order->isComplete())
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-4">Pickup Code</h3>
                    <form action="{{ route('admin.orders.update-pickup-code', $order) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="space-y-3">
                            <input type="text" name="pickup_code" value="{{ $order->pickup_code }}"
                                placeholder="Masukkan kode pickup..."
                                class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-gold focus:border-transparent text-center text-xl font-bold tracking-widest uppercase">
                            <button type="submit"
                                class="w-full bg-navy text-gold py-2 rounded-lg hover:bg-opacity-90 text-sm font-medium">
                                {{ $order->pickup_code ? 'Update' : 'Set' }} Pickup Code
                            </button>
                        </div>
                    </form>
                    @if($order->pickup_code)
                        <p class="text-xs text-gray-500 mt-3 text-center">Customer akan melihat kode ini di halaman order details.
                        </p>
                    @endif
                </div>
            @endif

            <!-- Moota Info -->
            @if($order->moota_mutation_id)
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-3">Moota Verification</h3>
                    <div class="text-sm">
                        <p class="text-gray-500">Mutation ID</p>
                        <p class="font-mono text-xs bg-gray-50 p-2 rounded mt-1 break-all">{{ $order->moota_mutation_id }}</p>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <div class="mt-6">
        <a href="{{ route('admin.orders.index') }}" class="text-gray-600 hover:text-navy">&larr; Back to Orders</a>
    </div>
@endsection