@extends('layouts.admin')

@section('title', 'Reports')
@section('page-title', 'Sales Reports')

@section('content')
    <div class="space-y-6">
        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <div>
                    <label class="block text-xs font-medium text-gray-500 mb-1">From</label>
                    <input type="date" name="date_from" value="{{ $dateFrom }}" class="px-4 py-2 border rounded-lg text-sm">
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-500 mb-1">To</label>
                    <input type="date" name="date_to" value="{{ $dateTo }}" class="px-4 py-2 border rounded-lg text-sm">
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-500 mb-1">Location</label>
                    <select name="store_location_id" class="px-4 py-2 border rounded-lg text-sm">
                        <option value="">All Locations</option>
                        @foreach($storeLocations as $loc)
                            <option value="{{ $loc->id }}" {{ $storeLocationId == $loc->id ? 'selected' : '' }}>{{ $loc->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <button type="submit"
                    class="bg-navy text-gold px-4 py-2 rounded-lg text-sm hover:bg-navy-light">Apply</button>
            </form>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4">
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <p class="text-xs text-gray-500 uppercase">Total Orders</p>
                <p class="text-2xl font-bold text-navy">{{ number_format($summary['total_orders']) }}</p>
            </div>
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <p class="text-xs text-gray-500 uppercase">Total Revenue</p>
                <p class="text-xl font-bold text-green-600">Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}
                </p>
            </div>
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <p class="text-xs text-gray-500 uppercase">Subtotal</p>
                <p class="text-xl font-bold text-navy">Rp {{ number_format($summary['total_subtotal'], 0, ',', '.') }}</p>
            </div>
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <p class="text-xs text-gray-500 uppercase">Total PPN</p>
                <p class="text-xl font-bold text-navy">Rp {{ number_format($summary['total_ppn'], 0, ',', '.') }}</p>
            </div>
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <p class="text-xs text-gray-500 uppercase">Average Order</p>
                <p class="text-xl font-bold text-gold">Rp {{ number_format($summary['average_order'], 0, ',', '.') }}</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Revenue by Day -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Revenue by Day</h3>
                <div class="space-y-2">
                    @forelse($revenueByDay as $day)
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <div>
                                <p class="text-sm font-medium">{{ \Carbon\Carbon::parse($day->date)->format('d M Y') }}</p>
                                <p class="text-xs text-gray-400">{{ $day->count }} orders</p>
                            </div>
                            <p class="font-bold text-navy">Rp {{ number_format($day->total, 0, ',', '.') }}</p>
                        </div>
                    @empty
                        <p class="text-gray-400 text-center py-4">No data</p>
                    @endforelse
                </div>
            </div>

            <!-- Revenue by Location -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Revenue by Location</h3>
                <div class="space-y-2">
                    @forelse($revenueByLocation as $loc)
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <div>
                                <p class="text-sm font-medium">{{ $loc->storeLocation->name ?? 'Unknown' }}</p>
                                <p class="text-xs text-gray-400">{{ $loc->count }} orders</p>
                            </div>
                            <p class="font-bold text-navy">Rp {{ number_format($loc->total, 0, ',', '.') }}</p>
                        </div>
                    @empty
                        <p class="text-gray-400 text-center py-4">No data</p>
                    @endforelse
                </div>
            </div>

            <!-- Top Products -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Top Products</h3>
                <div class="space-y-2">
                    @forelse($topProducts as $product)
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <div>
                                <p class="text-sm font-medium">{{ $product->product_name }}</p>
                                <p class="text-xs text-gray-400">{{ $product->total_qty }} sold</p>
                            </div>
                            <p class="font-bold text-navy">Rp {{ number_format($product->total_revenue, 0, ',', '.') }}</p>
                        </div>
                    @empty
                        <p class="text-gray-400 text-center py-4">No data</p>
                    @endforelse
                </div>
            </div>

            <!-- Status Breakdown -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Order Status Breakdown</h3>
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <span class="w-3 h-3 bg-yellow-500 rounded-full mr-2"></span>
                            <span class="text-sm">Pending</span>
                        </div>
                        <span class="font-bold">{{ $statusBreakdown['pending'] ?? 0 }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <span class="w-3 h-3 bg-blue-500 rounded-full mr-2"></span>
                            <span class="text-sm">Confirmed</span>
                        </div>
                        <span class="font-bold">{{ $statusBreakdown['confirm'] ?? 0 }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <span class="w-3 h-3 bg-green-500 rounded-full mr-2"></span>
                            <span class="text-sm">Complete</span>
                        </div>
                        <span class="font-bold">{{ $statusBreakdown['complete'] ?? 0 }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection