<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Order Form - Falala Chocolate</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Inter:wght@300;400;500;600&display=swap"
        rel="stylesheet">
    <style>
        :root {
            --navy: #1a2b4b;
            --gold: #c5a059;
            --gold-light: #e2cf9f;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
        }

        .brand-font {
            font-family: 'Playfair Display', serif;
        }

        .bg-navy {
            background-color: var(--navy);
        }

        .text-navy {
            color: var(--navy);
        }

        .text-gold {
            color: var(--gold);
        }

        .border-gold {
            border-color: var(--gold);
        }

        .bg-gold {
            background-color: var(--gold);
        }

        input:focus,
        select:focus,
        textarea:focus {
            outline: none;
            border-color: var(--gold);
            box-shadow: 0 0 0 2px rgba(197, 160, 89, 0.2);
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }

        .toast-notification {
            transform: translateY(100px);
            transition: all 0.3s ease;
        }

        .toast-notification.show {
            transform: translateY(0);
        }
    </style>
</head>

<body class="pb-12">
    <!-- Toast -->
    <div id="toastContainer" class="fixed bottom-10 left-1/2 -translate-x-1/2 z-[100] pointer-events-none">
        <div id="toast"
            class="toast-notification opacity-0 bg-navy text-gold px-6 py-3 rounded-full shadow-2xl flex items-center space-x-2 border border-gold/30">
            <span id="toastText" class="font-medium text-sm"></span>
        </div>
    </div>

    <!-- Header -->
    <header class="bg-navy py-10 mb-8 shadow-lg">
        <div class="container mx-auto px-4 flex flex-col items-center">
            <div class="flex items-center space-x-4 mb-3">
                <svg width="60" height="60" viewBox="0 0 100 100" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M50 85C50 85 20 65 20 35C20 20 35 15 50 35C65 15 80 20 80 35C80 65 50 85 50 85Z"
                        stroke="#c5a059" stroke-width="3" />
                    <path d="M40 45L50 55L60 45" stroke="#c5a059" stroke-width="2" />
                    <path d="M35 55L50 70L65 55" stroke="#c5a059" stroke-width="2" />
                </svg>
            </div>
            <h1 class="text-gold brand-font text-4xl tracking-widest uppercase text-center">Falala</h1>
            <p class="text-[#e2cf9f] tracking-[0.4em] text-xs uppercase mt-2">Chocolate</p>
        </div>
    </header>

    <main class="container mx-auto px-4 max-w-2xl">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden border border-gray-100">
            <div class="p-6 md:p-12">
                <h2 class="text-2xl font-semibold text-navy mb-8 border-b pb-4 flex items-center">
                    <span class="mr-2">Order Form</span>
                </h2>

                <form id="orderForm" class="space-y-8">
                    @csrf
                    <!-- Personal Info -->
                    <div class="space-y-5">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                            <div>
                                <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Nama
                                    Lengkap</label>
                                <input type="text" id="customer_name" name="customer_name" required
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-gray-50/50 transition-all"
                                    placeholder="Nama Anda">
                            </div>
                            <div>
                                <label
                                    class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">WhatsApp</label>
                                <input type="tel" id="customer_whatsapp" name="customer_whatsapp" required
                                    pattern="^(\+62|62|0)8[1-9][0-9]{6,10}$"
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-gray-50/50 transition-all"
                                    placeholder="08xx atau +628xx">
                                <p class="text-[10px] text-gray-400 mt-1">Format: 08xxxxxxxxx atau +628xxxxxxxxx</p>
                            </div>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Alamat
                                Lengkap</label>
                            <textarea id="customer_address" name="customer_address" rows="2" required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-gray-50/50 transition-all"
                                placeholder="Alamat pengiriman..."></textarea>
                        </div>
                    </div>

                    <!-- Products -->
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Pilihan
                            Produk</label>
                        <div class="space-y-3" id="productList">
                            @forelse($products as $product)
                                <div class="product-item flex items-center justify-between p-4 border border-gray-100 rounded-2xl bg-gray-50/30 hover:bg-white hover:border-gold hover:shadow-md transition-all"
                                    data-product-id="{{ $product->id }}" data-price="{{ $product->price }}"
                                    data-stock="{{ $product->stock }}">
                                    <div class="flex items-center space-x-4">
                                        <input type="checkbox"
                                            class="product-checkbox w-5 h-5 accent-[#1a2b4b] rounded-md cursor-pointer">
                                        <div>
                                            <p class="font-bold text-navy">{{ $product->name }}</p>
                                            <div class="flex items-center space-x-2">
                                                <p class="text-sm text-gold font-semibold">Rp
                                                    {{ number_format($product->price, 0, ',', '.') }}
                                                </p>
                                                <span
                                                    class="text-[10px] bg-navy/5 text-navy/60 px-2 py-0.5 rounded-full font-bold uppercase">Stok:
                                                    {{ $product->stock }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div
                                        class="flex items-center space-x-3 bg-white p-1 rounded-full border border-gray-100">
                                        <button type="button" onclick="adjustQty(this, -1)"
                                            class="w-8 h-8 rounded-full flex items-center justify-center hover:bg-navy hover:text-white transition-all text-navy border border-gray-100">-</button>
                                        <input type="number"
                                            class="qty-input w-8 text-center bg-transparent font-bold text-navy text-sm"
                                            value="0" min="0" readonly>
                                        <button type="button" onclick="adjustQty(this, 1)"
                                            class="w-8 h-8 rounded-full flex items-center justify-center hover:bg-navy hover:text-white transition-all text-navy border border-gray-100">+</button>
                                    </div>
                                </div>
                            @empty
                                <p class="text-gray-500 text-center py-8">Tidak ada produk tersedia saat ini.</p>
                            @endforelse
                        </div>
                    </div>

                    <!-- Pickup & Notes -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Pilihan
                                Store</label>
                            <select id="store_location_id" name="store_location_id" required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-gray-50/50 transition-all appearance-none cursor-pointer">
                                <option value="" disabled selected>Pilih Lokasi Pickup</option>
                                @foreach($locations as $location)
                                    <option value="{{ $location->id }}">{{ $location->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Catatan
                                Pesanan</label>
                            <input type="text" id="notes" name="notes"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-gray-50/50 transition-all"
                                placeholder="Contoh: Tanpa kacang, kartu ucapan...">
                        </div>
                    </div>

                    <!-- Hidden Bank Selection -->
                    <input type="hidden" id="bank_id" name="bank_id" value="{{ $defaultBank?->id }}">

                    <!-- Summary -->
                    <div class="bg-navy rounded-2xl p-6 md:p-8 text-white space-y-4 shadow-inner">
                        <div class="flex justify-between items-center opacity-70 text-sm">
                            <span>Subtotal</span>
                            <span id="displaySubtotal">Rp 0</span>
                        </div>
                        <div class="flex justify-between items-center opacity-70 text-sm">
                            <span>PPN (11%)</span>
                            <span id="displayPPN">Rp 0</span>
                        </div>
                        <div class="flex justify-between items-center text-[#e2cf9f] text-sm italic font-medium">
                            <span class="flex items-center">
                                Kode Unik Verifikasi
                                <svg class="w-3 h-3 ml-1 opacity-50" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                        clip-rule="evenodd"></path>
                                </svg>
                            </span>
                            <span id="displayUniqueCode">+ Rp 0</span>
                        </div>
                        <div class="h-px bg-white/10 my-4"></div>
                        <div class="flex justify-between items-center">
                            <span class="font-bold uppercase tracking-widest text-sm">Total Pembayaran</span>
                            <span id="displayTotal" class="text-2xl font-bold text-gold">Rp 0</span>
                        </div>
                        <p class="text-[10px] text-white/40 text-center italic mt-4">
                            Sistem akan otomatis memberikan kode unik 3 digit terakhir untuk memudahkan verifikasi
                            pembayaran Anda.
                        </p>
                    </div>

                    <!-- Payment Details - All Banks -->
                    @if($banks->count() > 0)
                        <div class="space-y-4">
                            <h3 class="text-navy font-bold flex items-center uppercase text-xs tracking-widest">
                                <svg class="w-5 h-5 mr-2 text-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z">
                                    </path>
                                </svg>
                                Detail Rekening Pembayaran
                            </h3>

                            @foreach($banks as $bank)
                                <div class="bg-orange-50/30 rounded-2xl p-6 border border-gold/20">
                                    <div class="flex items-center justify-between mb-4">
                                        <span
                                            class="bg-gold text-white text-[10px] px-2 py-1 rounded font-bold">{{ $bank->bank_name }}</span>
                                    </div>
                                    <div class="space-y-3">
                                        <div
                                            class="flex items-center justify-between bg-white p-4 rounded-xl shadow-sm border border-gray-100 group">
                                            <div>
                                                <p class="text-[10px] text-gray-400 uppercase font-bold tracking-tighter">Nomor
                                                    Rekening</p>
                                                <p class="accNumber text-xl font-bold text-navy tracking-widest">
                                                    {{ $bank->account_number }}</p>
                                            </div>
                                            <button type="button" onclick="copyToClipboard('{{ $bank->account_number }}')"
                                                class="text-gold hover:text-navy transition-all p-2 bg-gold/5 rounded-lg group-hover:scale-110">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2">
                                                    </path>
                                                </svg>
                                            </button>
                                        </div>
                                        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
                                            <p class="text-[10px] text-gray-400 uppercase font-bold tracking-tighter">Atas Nama
                                            </p>
                                            <p class="font-bold text-navy">{{ $bank->account_name }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Submit Button -->
                    <button type="submit" id="submitBtn"
                        class="w-full bg-navy text-gold py-5 rounded-2xl font-bold text-lg uppercase tracking-[0.2em] hover:bg-opacity-95 transition-all shadow-xl active:transform active:scale-[0.98] border border-gold/30 disabled:opacity-50 disabled:cursor-not-allowed">
                        Konfirmasi Order
                    </button>
                </form>
            </div>
        </div>

        <p class="text-center text-gray-400 text-[10px] uppercase tracking-widest mt-10">
            Falala Chocolate &copy; {{ date('Y') }}. Handcrafted in Bali.
        </p>
    </main>

    <!-- Success Modal -->
    <div id="successModal"
        class="fixed inset-0 bg-navy/80 backdrop-blur-sm z-50 flex items-center justify-center hidden p-6">
        <div
            class="bg-white rounded-3xl max-w-sm w-full p-10 text-center shadow-2xl scale-95 transition-transform duration-300">
            <div class="w-20 h-20 bg-gold/10 text-gold rounded-full flex items-center justify-center mx-auto mb-6">
                <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <h3 class="text-2xl font-bold text-navy mb-3 brand-font">Pesanan Diterima</h3>
            <p id="modalMessage" class="text-sm text-gray-600 mb-4 leading-relaxed">Terima kasih atas pesanannya. Tim
                kami akan segera menghubungi Anda melalui WhatsApp untuk konfirmasi.</p>
            <div id="modalOrderInfo" class="bg-gray-50 rounded-xl p-4 mb-6 text-left hidden">
                <p class="text-xs text-gray-500 mb-1">Nomor Order:</p>
                <p id="modalOrderNumber" class="font-bold text-navy"></p>
                <p class="text-xs text-gray-500 mt-3 mb-1">Total Pembayaran:</p>
                <p id="modalTotalAmount" class="font-bold text-gold text-xl"></p>
            </div>
            <button onclick="closeModal()"
                class="w-full bg-navy text-gold py-4 rounded-xl font-bold uppercase tracking-wider">Tutup</button>
        </div>
    </div>

    <script>
        const PPN_RATE = 0.11;
        let uniqueCode = 0;

        function formatIDR(amount) {
            return new Intl.NumberFormat('id-ID', {
                style: 'currency',
                currency: 'IDR',
                minimumFractionDigits: 0
            }).format(amount).replace('Rp', 'Rp ');
        }

        function showToast(message) {
            const toast = document.getElementById('toast');
            const toastText = document.getElementById('toastText');
            toastText.innerText = message;
            toast.classList.remove('opacity-0');
            toast.classList.add('show', 'opacity-100');
            setTimeout(() => {
                toast.classList.remove('show', 'opacity-100');
                toast.classList.add('opacity-0');
            }, 3000);
        }

        function copyToClipboard(text) {
            navigator.clipboard.writeText(text.replace(/\s/g, ''));
            showToast("Nomor rekening berhasil disalin!");
        }

        function adjustQty(btn, delta) {
            const item = btn.closest('.product-item');
            const input = item.querySelector('.qty-input');
            const checkbox = item.querySelector('.product-checkbox');
            const maxStock = parseInt(item.dataset.stock);
            let val = parseInt(input.value) + delta;

            if (val < 0) val = 0;
            if (val > maxStock) {
                showToast(`Maaf, stok hanya tersedia ${maxStock} item.`);
                val = maxStock;
            }

            input.value = val;
            checkbox.checked = val > 0;
            calculateTotal();
        }

        function calculateTotal() {
            let subtotal = 0;
            let hasSelection = false;

            document.querySelectorAll('.product-item').forEach(item => {
                const checkbox = item.querySelector('.product-checkbox');
                const qtyInput = item.querySelector('.qty-input');
                const qty = parseInt(qtyInput.value);

                if (qty > 0) {
                    checkbox.checked = true;
                    hasSelection = true;
                    subtotal += parseFloat(item.dataset.price) * qty;
                } else {
                    checkbox.checked = false;
                }
            });

            if (hasSelection) {
                if (uniqueCode === 0) {
                    uniqueCode = Math.floor(Math.random() * 899) + 100;
                }
                const ppn = subtotal * PPN_RATE;
                const total = subtotal + ppn + uniqueCode;

                document.getElementById('displaySubtotal').innerText = formatIDR(subtotal);
                document.getElementById('displayPPN').innerText = formatIDR(ppn);
                document.getElementById('displayUniqueCode').innerText = `+ Rp ${uniqueCode}`;
                document.getElementById('displayTotal').innerText = formatIDR(total);
            } else {
                uniqueCode = 0;
                document.getElementById('displaySubtotal').innerText = 'Rp 0';
                document.getElementById('displayPPN').innerText = 'Rp 0';
                document.getElementById('displayUniqueCode').innerText = '+ Rp 0';
                document.getElementById('displayTotal').innerText = 'Rp 0';
            }
        }

        function closeModal() {
            document.getElementById('successModal').classList.add('hidden');
        }

        // Initialize checkbox listeners
        document.querySelectorAll('.product-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', function () {
                const item = this.closest('.product-item');
                const qtyInput = item.querySelector('.qty-input');
                if (this.checked) {
                    if (parseInt(qtyInput.value) === 0) qtyInput.value = 1;
                } else {
                    qtyInput.value = 0;
                }
                calculateTotal();
            });
        });

        // Form submission
        document.getElementById('orderForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            const submitBtn = document.getElementById('submitBtn');

            // Collect items
            const items = [];
            document.querySelectorAll('.product-item').forEach(item => {
                const qty = parseInt(item.querySelector('.qty-input').value);
                if (qty > 0) {
                    items.push({
                        product_id: parseInt(item.dataset.productId),
                        quantity: qty
                    });
                }
            });

            if (items.length === 0) {
                showToast('Pilih minimal satu produk.');
                return;
            }

            // Validate nama
            const customerName = document.getElementById('customer_name').value.trim();
            if (!customerName) {
                showToast('Nama lengkap wajib diisi.');
                document.getElementById('customer_name').focus();
                return;
            }

            // Validate WhatsApp format
            const whatsapp = document.getElementById('customer_whatsapp').value.trim();
            const waPattern = /^(\+62|62|0)8[1-9][0-9]{6,10}$/;
            if (!waPattern.test(whatsapp)) {
                showToast('Format nomor WhatsApp tidak valid. Gunakan format 08xx atau +628xx.');
                document.getElementById('customer_whatsapp').focus();
                return;
            }

            // Validate alamat
            const alamat = document.getElementById('customer_address').value.trim();
            if (!alamat) {
                showToast('Alamat lengkap wajib diisi.');
                document.getElementById('customer_address').focus();
                return;
            }

            // Validate store location
            const storeId = document.getElementById('store_location_id').value;
            if (!storeId) {
                showToast('Pilih lokasi store untuk pickup.');
                document.getElementById('store_location_id').focus();
                return;
            }

            submitBtn.disabled = true;
            submitBtn.innerText = 'Memproses...';

            try {
                const response = await fetch('{{ route("booking.store") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({
                        customer_name: document.getElementById('customer_name').value,
                        customer_whatsapp: document.getElementById('customer_whatsapp').value,
                        customer_address: document.getElementById('customer_address').value,
                        notes: document.getElementById('notes').value,
                        store_location_id: document.getElementById('store_location_id').value,
                        bank_id: document.getElementById('bank_id').value,
                        items: items
                    })
                });

                const data = await response.json();

                if (data.success) {
                    // Redirect to order details page
                    window.location.href = data.redirect_url;
                } else {
                    if (data.errors) {
                        const firstError = Object.values(data.errors)[0];
                        showToast(Array.isArray(firstError) ? firstError[0] : firstError);
                    } else {
                        showToast(data.message || 'Terjadi kesalahan.');
                    }
                }
            } catch (error) {
                showToast('Koneksi gagal. Silakan coba lagi.');
                console.error(error);
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerText = 'Konfirmasi Order';
            }
        });
    </script>
</body>

</html>