<?php

use App\Http\Controllers\BookingController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\BankController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\StoreLocationController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ReportController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Public Booking Routes
Route::get('/', [BookingController::class, 'index'])->name('booking.index');
Route::get('/booking', [BookingController::class, 'index']);
Route::post('/booking', [BookingController::class, 'store'])->name('booking.store');
Route::get('/order-details/{orderNumber}', [BookingController::class, 'confirmation'])->name('booking.confirmation');
Route::get('/order-details/{orderNumber}/status', [BookingController::class, 'checkStatus'])->name('booking.status');
Route::post('/order-details/{orderNumber}/upload-proof', [BookingController::class, 'uploadPaymentProof'])->name('booking.upload-proof');

// Admin Routes
Route::prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // Banks
    Route::resource('banks', BankController::class)->except(['show']);
    Route::post('banks/sync', [BankController::class, 'syncFromMoota'])->name('banks.sync');

    // Products
    Route::resource('products', ProductController::class)->except(['show']);
    Route::patch('products/{product}/stock', [ProductController::class, 'updateStock'])->name('products.stock');

    // Store Locations
    Route::resource('locations', StoreLocationController::class)->except(['show']);

    // Orders
    Route::get('orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('orders/export', [OrderController::class, 'export'])->name('orders.export');
    Route::get('orders/{order}', [OrderController::class, 'show'])->name('orders.show');
    Route::post('orders/{order}/confirm', [OrderController::class, 'confirm'])->name('orders.confirm');
    Route::post('orders/{order}/complete', [OrderController::class, 'complete'])->name('orders.complete');
    Route::post('orders/{order}/cancel', [OrderController::class, 'cancel'])->name('orders.cancel');
    Route::post('orders/{order}/verify', [OrderController::class, 'verifyPayment'])->name('orders.verify');
    Route::patch('orders/{order}/pickup-code', [OrderController::class, 'updatePickupCode'])->name('orders.update-pickup-code');

    // Reports
    Route::get('reports', [ReportController::class, 'index'])->name('reports.index');
});
