<?php $__env->startSection('title', 'Order Detail'); ?>
<?php $__env->startSection('page-title', 'Order ' . $order->order_number); ?>

<?php $__env->startSection('content'); ?>
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Order Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Items -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Order Items</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="text-xs text-gray-500 uppercase bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left">Product</th>
                                <th class="px-4 py-2 text-center">Qty</th>
                                <th class="px-4 py-2 text-right">Price</th>
                                <th class="px-4 py-2 text-right">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-4 py-3"><?php echo e($item->product_name); ?></td>
                                    <td class="px-4 py-3 text-center"><?php echo e($item->quantity); ?></td>
                                    <td class="px-4 py-3 text-right">Rp <?php echo e(number_format($item->unit_price, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right font-medium">Rp
                                        <?php echo e(number_format($item->subtotal, 0, ',', '.')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4 pt-4 border-t space-y-2 text-sm">
                    <div class="flex justify-between"><span class="text-gray-500">Subtotal</span><span>Rp
                            <?php echo e(number_format($order->subtotal, 0, ',', '.')); ?></span></div>
                    <div class="flex justify-between"><span class="text-gray-500">PPN (11%)</span><span>Rp
                            <?php echo e(number_format($order->ppn, 0, ',', '.')); ?></span></div>
                    <div class="flex justify-between text-gold"><span>Kode Unik</span><span>+ Rp
                            <?php echo e($order->unique_code); ?></span></div>
                    <div class="flex justify-between text-lg font-bold border-t pt-2"><span>Total</span><span
                            class="text-navy">Rp <?php echo e(number_format($order->total_amount, 0, ',', '.')); ?></span></div>
                </div>
            </div>

            <!-- Customer Info -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Customer Information</h3>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <p class="text-gray-500">Name</p>
                        <p class="font-medium"><?php echo e($order->customer_name); ?></p>
                    </div>
                    <div>
                        <p class="text-gray-500">WhatsApp</p>
                        <p class="font-medium"><?php echo e($order->customer_whatsapp); ?></p>
                    </div>
                    <div class="col-span-2">
                        <p class="text-gray-500">Address</p>
                        <p class="font-medium"><?php echo e($order->customer_address); ?></p>
                    </div>
                    <div>
                        <p class="text-gray-500">Pickup Location</p>
                        <p class="font-medium"><?php echo e($order->storeLocation->name ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-gray-500">Bank</p>
                        <p class="font-medium"><?php echo e($order->bank->bank_name ?? '-'); ?></p>
                    </div>
                    <?php if($order->notes): ?>
                        <div class="col-span-2">
                            <p class="text-gray-500">Notes</p>
                            <p class="font-medium"><?php echo e($order->notes); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Payment Proof -->
            <?php if($order->payment_proof): ?>
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-4">Bukti Transfer</h3>
                    <a href="<?php echo e(asset($order->payment_proof)); ?>" target="_blank" class="block">
                        <img src="<?php echo e(asset($order->payment_proof)); ?>" alt="Bukti Transfer"
                            class="w-full rounded-lg border border-gray-200 hover:opacity-90 transition-opacity cursor-pointer">
                    </a>
                    <p class="text-xs text-gray-500 mt-2 text-center">Klik gambar untuk melihat ukuran penuh</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status Card -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h3 class="font-semibold text-navy mb-4">Order Status</h3>
                <div class="text-center py-4">
                    <?php if($order->status === 'pending'): ?>
                        <div
                            class="inline-flex items-center px-4 py-2 bg-yellow-100 text-yellow-800 rounded-full text-sm font-semibold">
                            Pending Payment</div>
                    <?php elseif($order->status === 'confirm'): ?>
                        <div
                            class="inline-flex items-center px-4 py-2 bg-blue-100 text-blue-800 rounded-full text-sm font-semibold">
                            Payment Confirmed</div>
                    <?php else: ?>
                        <div
                            class="inline-flex items-center px-4 py-2 bg-green-100 text-green-800 rounded-full text-sm font-semibold">
                            Completed</div>
                    <?php endif; ?>
                </div>

                <div class="mt-4 space-y-2 text-sm">
                    <div class="flex justify-between"><span
                            class="text-gray-500">Created</span><span><?php echo e($order->created_at->format('d M Y H:i')); ?></span>
                    </div>
                    <?php if($order->expired_at): ?>
                        <div class="flex justify-between"><span class="text-gray-500">Expires</span><span
                                class="<?php echo e($order->isExpired() ? 'text-red-600' : ''); ?>"><?php echo e($order->expired_at->format('d M Y H:i')); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if($order->paid_at): ?>
                        <div class="flex justify-between"><span class="text-gray-500">Paid</span><span
                                class="text-green-600"><?php echo e($order->paid_at->format('d M Y H:i')); ?></span></div>
                    <?php endif; ?>
                </div>

                <!-- Actions -->
                <div class="mt-6 space-y-2">
                    <?php if($order->isPending()): ?>
                        <form action="<?php echo e(route('admin.orders.verify', $order)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                class="w-full bg-blue-500 text-white py-2 rounded-lg hover:bg-blue-600 text-sm font-medium">Verify
                                Payment (Moota)</button>
                        </form>
                        <form action="<?php echo e(route('admin.orders.confirm', $order)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                class="w-full bg-gold text-navy py-2 rounded-lg hover:bg-gold-dark text-sm font-medium">Manual
                                Confirm</button>
                        </form>
                        <form action="<?php echo e(route('admin.orders.cancel', $order)); ?>" method="POST"
                            onsubmit="return confirm('Cancel order ini?')">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                class="w-full bg-red-500 text-white py-2 rounded-lg hover:bg-red-600 text-sm font-medium">Cancel
                                Order</button>
                        </form>
                    <?php elseif($order->isConfirmed()): ?>
                        <form action="<?php echo e(route('admin.orders.complete', $order)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                class="w-full bg-green-500 text-white py-2 rounded-lg hover:bg-green-600 text-sm font-medium">Mark
                                as Complete</button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Pickup Code -->
            <?php if($order->isConfirmed() || $order->isComplete()): ?>
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-4">Pickup Code</h3>
                    <form action="<?php echo e(route('admin.orders.update-pickup-code', $order)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <div class="space-y-3">
                            <input type="text" name="pickup_code" value="<?php echo e($order->pickup_code); ?>"
                                placeholder="Masukkan kode pickup..."
                                class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-gold focus:border-transparent text-center text-xl font-bold tracking-widest uppercase">
                            <button type="submit"
                                class="w-full bg-navy text-gold py-2 rounded-lg hover:bg-opacity-90 text-sm font-medium">
                                <?php echo e($order->pickup_code ? 'Update' : 'Set'); ?> Pickup Code
                            </button>
                        </div>
                    </form>
                    <?php if($order->pickup_code): ?>
                        <p class="text-xs text-gray-500 mt-3 text-center">Customer akan melihat kode ini di halaman order details.
                        </p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Moota Info -->
            <?php if($order->moota_mutation_id): ?>
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="font-semibold text-navy mb-3">Moota Verification</h3>
                    <div class="text-sm">
                        <p class="text-gray-500">Mutation ID</p>
                        <p class="font-mono text-xs bg-gray-50 p-2 rounded mt-1 break-all"><?php echo e($order->moota_mutation_id); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="mt-6">
        <a href="<?php echo e(route('admin.orders.index')); ?>" class="text-gray-600 hover:text-navy">&larr; Back to Orders</a>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sunarta25/gotra/PROTOTYPE/Booking_Moota/resources/views/admin/orders/show.blade.php ENDPATH**/ ?>